/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;

public class SonarLintBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.sonarlint.eclipse.core.sonarlintBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        IResourceDelta delta;
        if (kind != 6 && (delta = this.getDelta(this.getProject())) != null) {
            SonarLintBuilder.incrementalBuild(delta);
        }
        return null;
    }

    private static void incrementalBuild(IResourceDelta delta) {
        final HashMap filesPerProject = new HashMap();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (!SonarLintBuilder.shouldAnalyze(delta, resource)) {
                        return false;
                    }
                    IFile file = (IFile)resource.getAdapter(IFile.class);
                    if (file == null) {
                        return true;
                    }
                    IProject project = resource.getProject();
                    if (!filesPerProject.containsKey(project)) {
                        filesPerProject.put(project, new ArrayList());
                    }
                    ((Collection)filesPerProject.get(project)).add(file);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            SonarLintCorePlugin.getDefault().error("Error during builder", e);
        }
        for (Map.Entry entry : filesPerProject.entrySet()) {
            AnalyzeProjectRequest request = new AnalyzeProjectRequest((IProject)entry.getKey(), (Collection)entry.getValue());
            new AnalyzeProjectJob(request).schedule();
        }
    }

    public static boolean shouldAnalyze(IResourceDelta delta, IResource resource) {
        if (delta != null && delta.getKind() == 2) {
            return false;
        }
        return SonarLintBuilder.shouldAnalyze(resource);
    }

    public static boolean shouldAnalyze(IResource resource) {
        if (!resource.exists() || resource.isDerived(512) || resource.isHidden(512)) {
            return false;
        }
        return !resource.getName().startsWith(".");
    }

    public static void addBuilder(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = desc.newCommand();
            command.setBuilderName(BUILDER_ID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[commands.length] = command;
            desc.setBuildSpec(newCommands);
            project.setDescription(desc, null);
        }
    }
}

